"use strict";
/**
 * Wallet Service
 * Comprehensive wallet management for all wallet types and operations
 *
 * This service provides:
 * - Atomic balance operations (credit, debit, hold, release, transfer)
 * - Type-specific wallet creation (FIAT, SPOT, ECO, FUTURES, COPY_TRADING)
 * - Multi-chain address generation (EVM, UTXO, SOL, TRON, XMR, TON)
 * - Encrypted wallet data management
 * - Off-chain/on-chain balance tracking via ledger
 * - UTXO management for BTC-like chains
 * - HD master wallet management
 * - Comprehensive audit logging
 *
 * Safety features:
 * - Idempotency for all operations
 * - Row-level locking for concurrency
 * - Integer arithmetic for precision
 * - Database transactions for atomicity
 * - Complete audit trail
 *
 * @example
 * // Credit a wallet
 * const result = await walletService.credit({
 *   idempotencyKey: `deposit_${txId}`,
 *   userId: "user-123",
 *   walletType: "SPOT",
 *   currency: "USDT",
 *   amount: 100,
 *   operationType: "DEPOSIT",
 *   description: "Deposit from exchange"
 * });
 *
 * @example
 * // Create an ECO wallet with addresses
 * const { wallet, addresses } = await walletCreationService.createWallet({
 *   userId: "user-123",
 *   type: "ECO",
 *   currency: "ETH",
 *   generateAddresses: true
 * });
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChainConfig = exports.getPrecision = exports.UTXO_TX_SIZE = exports.DUST_LIMITS = exports.CHAIN_CONFIG = exports.PRECISION_CONFIG = exports.toWalletError = exports.isWalletError = exports.UtxoError = exports.LedgerError = exports.TransferError = exports.NoActiveTokensError = exports.NetworkNotConfiguredError = exports.WalletDataNotFoundError = exports.EncryptionError = exports.ChainServiceUnavailableError = exports.AddressGenerationError = exports.MasterWalletExistsError = exports.MasterWalletNotFoundError = exports.WalletExistsError = exports.InvalidAmountError = exports.InvalidWalletTypeError = exports.WalletDisabledError = exports.NegativeInOrderError = exports.InsufficientHeldFundsError = exports.NegativeBalanceError = exports.PrecisionError = exports.ConcurrencyError = exports.DuplicateOperationError = exports.WalletNotFoundError = exports.InsufficientFundsError = exports.WalletError = exports.precisionCacheService = exports.PrecisionCacheService = exports.auditLogger = exports.AuditLogger = exports.masterWalletService = exports.MasterWalletService = exports.utxoService = exports.UtxoService = exports.ledgerService = exports.LedgerService = exports.addressGenerationService = exports.AddressGenerationService = exports.walletDataService = exports.WalletDataService = exports.walletCreationService = exports.WalletCreationService = exports.walletService = exports.WalletService = void 0;
exports.safeSum = exports.ensureNonNegative = exports.clamp = exports.calculateAmountAfterFee = exports.calculateFee = exports.calculatePercentage = exports.parseWithPrecision = exports.formatWithPrecision = exports.fromSmallestUnit = exports.toSmallestUnit = exports.safeLessThanOrEqual = exports.safeLessThan = exports.safeGreaterThanOrEqual = exports.safeGreaterThan = exports.safeEquals = exports.safeDivide = exports.safeMultiply = exports.safeSubtract = exports.safeAdd = exports.validatePrecision = exports.roundToPrecision = exports.isSpecialChain = exports.isUtxoChain = exports.isEvmChain = exports.getDustLimit = void 0;
// ============================================
// SERVICES
// ============================================
var WalletService_1 = require("./WalletService");
Object.defineProperty(exports, "WalletService", { enumerable: true, get: function () { return WalletService_1.WalletService; } });
Object.defineProperty(exports, "walletService", { enumerable: true, get: function () { return WalletService_1.walletService; } });
var WalletCreationService_1 = require("./WalletCreationService");
Object.defineProperty(exports, "WalletCreationService", { enumerable: true, get: function () { return WalletCreationService_1.WalletCreationService; } });
Object.defineProperty(exports, "walletCreationService", { enumerable: true, get: function () { return WalletCreationService_1.walletCreationService; } });
var WalletDataService_1 = require("./WalletDataService");
Object.defineProperty(exports, "WalletDataService", { enumerable: true, get: function () { return WalletDataService_1.WalletDataService; } });
Object.defineProperty(exports, "walletDataService", { enumerable: true, get: function () { return WalletDataService_1.walletDataService; } });
var AddressGenerationService_1 = require("./AddressGenerationService");
Object.defineProperty(exports, "AddressGenerationService", { enumerable: true, get: function () { return AddressGenerationService_1.AddressGenerationService; } });
Object.defineProperty(exports, "addressGenerationService", { enumerable: true, get: function () { return AddressGenerationService_1.addressGenerationService; } });
var LedgerService_1 = require("./LedgerService");
Object.defineProperty(exports, "LedgerService", { enumerable: true, get: function () { return LedgerService_1.LedgerService; } });
Object.defineProperty(exports, "ledgerService", { enumerable: true, get: function () { return LedgerService_1.ledgerService; } });
var UtxoService_1 = require("./UtxoService");
Object.defineProperty(exports, "UtxoService", { enumerable: true, get: function () { return UtxoService_1.UtxoService; } });
Object.defineProperty(exports, "utxoService", { enumerable: true, get: function () { return UtxoService_1.utxoService; } });
var MasterWalletService_1 = require("./MasterWalletService");
Object.defineProperty(exports, "MasterWalletService", { enumerable: true, get: function () { return MasterWalletService_1.MasterWalletService; } });
Object.defineProperty(exports, "masterWalletService", { enumerable: true, get: function () { return MasterWalletService_1.masterWalletService; } });
var AuditLogger_1 = require("./audit/AuditLogger");
Object.defineProperty(exports, "AuditLogger", { enumerable: true, get: function () { return AuditLogger_1.AuditLogger; } });
Object.defineProperty(exports, "auditLogger", { enumerable: true, get: function () { return AuditLogger_1.auditLogger; } });
var PrecisionCacheService_1 = require("./PrecisionCacheService");
Object.defineProperty(exports, "PrecisionCacheService", { enumerable: true, get: function () { return PrecisionCacheService_1.PrecisionCacheService; } });
Object.defineProperty(exports, "precisionCacheService", { enumerable: true, get: function () { return PrecisionCacheService_1.precisionCacheService; } });
// ============================================
// ERRORS
// ============================================
var errors_1 = require("./errors");
Object.defineProperty(exports, "WalletError", { enumerable: true, get: function () { return errors_1.WalletError; } });
Object.defineProperty(exports, "InsufficientFundsError", { enumerable: true, get: function () { return errors_1.InsufficientFundsError; } });
Object.defineProperty(exports, "WalletNotFoundError", { enumerable: true, get: function () { return errors_1.WalletNotFoundError; } });
Object.defineProperty(exports, "DuplicateOperationError", { enumerable: true, get: function () { return errors_1.DuplicateOperationError; } });
Object.defineProperty(exports, "ConcurrencyError", { enumerable: true, get: function () { return errors_1.ConcurrencyError; } });
Object.defineProperty(exports, "PrecisionError", { enumerable: true, get: function () { return errors_1.PrecisionError; } });
Object.defineProperty(exports, "NegativeBalanceError", { enumerable: true, get: function () { return errors_1.NegativeBalanceError; } });
Object.defineProperty(exports, "InsufficientHeldFundsError", { enumerable: true, get: function () { return errors_1.InsufficientHeldFundsError; } });
Object.defineProperty(exports, "NegativeInOrderError", { enumerable: true, get: function () { return errors_1.NegativeInOrderError; } });
Object.defineProperty(exports, "WalletDisabledError", { enumerable: true, get: function () { return errors_1.WalletDisabledError; } });
Object.defineProperty(exports, "InvalidWalletTypeError", { enumerable: true, get: function () { return errors_1.InvalidWalletTypeError; } });
Object.defineProperty(exports, "InvalidAmountError", { enumerable: true, get: function () { return errors_1.InvalidAmountError; } });
Object.defineProperty(exports, "WalletExistsError", { enumerable: true, get: function () { return errors_1.WalletExistsError; } });
Object.defineProperty(exports, "MasterWalletNotFoundError", { enumerable: true, get: function () { return errors_1.MasterWalletNotFoundError; } });
Object.defineProperty(exports, "MasterWalletExistsError", { enumerable: true, get: function () { return errors_1.MasterWalletExistsError; } });
Object.defineProperty(exports, "AddressGenerationError", { enumerable: true, get: function () { return errors_1.AddressGenerationError; } });
Object.defineProperty(exports, "ChainServiceUnavailableError", { enumerable: true, get: function () { return errors_1.ChainServiceUnavailableError; } });
Object.defineProperty(exports, "EncryptionError", { enumerable: true, get: function () { return errors_1.EncryptionError; } });
Object.defineProperty(exports, "WalletDataNotFoundError", { enumerable: true, get: function () { return errors_1.WalletDataNotFoundError; } });
Object.defineProperty(exports, "NetworkNotConfiguredError", { enumerable: true, get: function () { return errors_1.NetworkNotConfiguredError; } });
Object.defineProperty(exports, "NoActiveTokensError", { enumerable: true, get: function () { return errors_1.NoActiveTokensError; } });
Object.defineProperty(exports, "TransferError", { enumerable: true, get: function () { return errors_1.TransferError; } });
Object.defineProperty(exports, "LedgerError", { enumerable: true, get: function () { return errors_1.LedgerError; } });
Object.defineProperty(exports, "UtxoError", { enumerable: true, get: function () { return errors_1.UtxoError; } });
Object.defineProperty(exports, "isWalletError", { enumerable: true, get: function () { return errors_1.isWalletError; } });
Object.defineProperty(exports, "toWalletError", { enumerable: true, get: function () { return errors_1.toWalletError; } });
// ============================================
// CONSTANTS
// ============================================
var constants_1 = require("./constants");
Object.defineProperty(exports, "PRECISION_CONFIG", { enumerable: true, get: function () { return constants_1.PRECISION_CONFIG; } });
Object.defineProperty(exports, "CHAIN_CONFIG", { enumerable: true, get: function () { return constants_1.CHAIN_CONFIG; } });
Object.defineProperty(exports, "DUST_LIMITS", { enumerable: true, get: function () { return constants_1.DUST_LIMITS; } });
Object.defineProperty(exports, "UTXO_TX_SIZE", { enumerable: true, get: function () { return constants_1.UTXO_TX_SIZE; } });
Object.defineProperty(exports, "getPrecision", { enumerable: true, get: function () { return constants_1.getPrecision; } });
Object.defineProperty(exports, "getChainConfig", { enumerable: true, get: function () { return constants_1.getChainConfig; } });
Object.defineProperty(exports, "getDustLimit", { enumerable: true, get: function () { return constants_1.getDustLimit; } });
Object.defineProperty(exports, "isEvmChain", { enumerable: true, get: function () { return constants_1.isEvmChain; } });
Object.defineProperty(exports, "isUtxoChain", { enumerable: true, get: function () { return constants_1.isUtxoChain; } });
Object.defineProperty(exports, "isSpecialChain", { enumerable: true, get: function () { return constants_1.isSpecialChain; } });
// ============================================
// UTILITIES
// ============================================
var precision_1 = require("./utils/precision");
Object.defineProperty(exports, "roundToPrecision", { enumerable: true, get: function () { return precision_1.roundToPrecision; } });
Object.defineProperty(exports, "validatePrecision", { enumerable: true, get: function () { return precision_1.validatePrecision; } });
Object.defineProperty(exports, "safeAdd", { enumerable: true, get: function () { return precision_1.safeAdd; } });
Object.defineProperty(exports, "safeSubtract", { enumerable: true, get: function () { return precision_1.safeSubtract; } });
Object.defineProperty(exports, "safeMultiply", { enumerable: true, get: function () { return precision_1.safeMultiply; } });
Object.defineProperty(exports, "safeDivide", { enumerable: true, get: function () { return precision_1.safeDivide; } });
Object.defineProperty(exports, "safeEquals", { enumerable: true, get: function () { return precision_1.safeEquals; } });
Object.defineProperty(exports, "safeGreaterThan", { enumerable: true, get: function () { return precision_1.safeGreaterThan; } });
Object.defineProperty(exports, "safeGreaterThanOrEqual", { enumerable: true, get: function () { return precision_1.safeGreaterThanOrEqual; } });
Object.defineProperty(exports, "safeLessThan", { enumerable: true, get: function () { return precision_1.safeLessThan; } });
Object.defineProperty(exports, "safeLessThanOrEqual", { enumerable: true, get: function () { return precision_1.safeLessThanOrEqual; } });
Object.defineProperty(exports, "toSmallestUnit", { enumerable: true, get: function () { return precision_1.toSmallestUnit; } });
Object.defineProperty(exports, "fromSmallestUnit", { enumerable: true, get: function () { return precision_1.fromSmallestUnit; } });
Object.defineProperty(exports, "formatWithPrecision", { enumerable: true, get: function () { return precision_1.formatWithPrecision; } });
Object.defineProperty(exports, "parseWithPrecision", { enumerable: true, get: function () { return precision_1.parseWithPrecision; } });
Object.defineProperty(exports, "calculatePercentage", { enumerable: true, get: function () { return precision_1.calculatePercentage; } });
Object.defineProperty(exports, "calculateFee", { enumerable: true, get: function () { return precision_1.calculateFee; } });
Object.defineProperty(exports, "calculateAmountAfterFee", { enumerable: true, get: function () { return precision_1.calculateAmountAfterFee; } });
Object.defineProperty(exports, "clamp", { enumerable: true, get: function () { return precision_1.clamp; } });
Object.defineProperty(exports, "ensureNonNegative", { enumerable: true, get: function () { return precision_1.ensureNonNegative; } });
Object.defineProperty(exports, "safeSum", { enumerable: true, get: function () { return precision_1.safeSum; } });
// ============================================
// DEFAULT EXPORT - Main Wallet Service
// ============================================
const WalletService_2 = require("./WalletService");
exports.default = WalletService_2.walletService;
