"use strict";
// /server/api/ecosystem/custodialWallets/index.get.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const db_1 = require("@b/db");
const constants_1 = require("@b/utils/constants");
const query_1 = require("@b/utils/query");
const utils_1 = require("./utils");
exports.metadata = {
    summary: "List all ecosystem custodial wallets",
    description: "Retrieves a paginated list of ecosystem custodial wallets with optional filtering and sorting. Each wallet includes its address, chain, network, status, and associated master wallet information.",
    operationId: "listEcosystemCustodialWallets",
    tags: ["Admin", "Ecosystem", "Wallet"],
    parameters: constants_1.crudParameters,
    responses: {
        200: {
            description: "Ecosystem custodial wallets retrieved successfully",
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            items: {
                                type: "array",
                                items: {
                                    type: "object",
                                    properties: utils_1.ecosystemCustodialWalletSchema,
                                },
                            },
                            pagination: constants_1.paginationSchema,
                        },
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("Ecosystem Custodial Wallets"),
        500: query_1.serverErrorResponse,
    },
    requiresAuth: true,
    permission: "view.ecosystem.custodial.wallet",
    demoMask: ["items.address", "items.masterWallet.address"],
};
exports.default = async (data) => {
    const { query, ctx } = data;
    ctx === null || ctx === void 0 ? void 0 : ctx.step("Fetching custodial wallets list");
    const result = await (0, query_1.getFiltered)({
        model: db_1.models.ecosystemCustodialWallet,
        query,
        sortField: query.sortField || "chain",
        includeModels: [
            {
                model: db_1.models.ecosystemMasterWallet,
                as: "masterWallet",
                attributes: ["id", "chain", "address"],
            },
        ],
    });
    ctx === null || ctx === void 0 ? void 0 : ctx.success(`Retrieved ${result.items.length} custodial wallets`);
    return result;
};
